## Quote expansions in this for loop glob to prevent wordsplitting, e.g. "$dir"/*.txt .

### Problematic code:

```sh
for file in $dir/*.txt
do
  echo "Found $file"
done
```

### Correct code:

```sh
for file in "$dir"/*.txt
do
  echo "Found $file"
done
```

### Rationale:

When iterating over globs containing expansions, you can still quote all expansions in the path to better handle whitespace and special characters.

Just make sure glob characters are outside quotes. `"$dir/*.txt"` will not glob expand, but `"$dir"/*.txt` or `"$dir"/*."$ext"` will. 

### Exceptions:

Exceptions similar to [[SC2086]] apply. If the variable is expected to contain globs, such as if `dir="tmp/**"` in the example, you can ignore this message.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC2231)

