## Use `-n` instead of `! -z`.

(or "Use `-z` instead of `! -n`")

### Problematic code:

```sh
if [ ! -n "$JAVA_HOME" ]; then echo "JAVA_HOME not specified"; fi
if [ ! -z "$STY" ];       then echo "You are already running screen"; fi
```

### Correct code:

```sh
if [ -z "$JAVA_HOME" ]; then echo "JAVA_HOME not specified"; fi
if [ -n "$STY" ];       then echo "You are already running screen"; fi
```

### Rationale:

You have negated `test -z` or `test -n`, resulting in a needless double-negative. You can just use the other operator instead:

    # Identical tests to verify that a value is assigned
    [ ! -z foo ] # Not has no value
    [ -n foo ]   # Has value

    # Identical tests to verify that a value is empty
    [ ! -n foo ] # Not is non-empty
    [ -z foo ]   # Is empty

### Exceptions:

This is a stylistic issue that does not affect correctness. If you prefer the original expression, you can [[Ignore]] it with a directive or flag.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
* [Bash reference manual for -z and -n](https://www.gnu.org/software/bash/manual/html_node/Bash-Conditional-Expressions.html#Bash-Conditional-Expressions).
[Source](https://github.com/koalaman/shellcheck/wiki/SC2236)

