
Hardcoding a URI makes it difficult to test a program: path literals are not always portable across operating systems, a given absolute path may not exist on a specific test environment, a specified Internet URL may not be available when executing the tests, production environment filesystems usually differ from the development environment, ...etc. For all those reasons, a URI should never be hardcoded. Instead, it should be replaced by customizable parameter.

Further even if the elements of a URI are obtained dynamically, portability can still be limited if the path-delimiters are hardcoded.

This rule raises an issue when URI's or path delimiters are hardcoded.

## Exceptions

This rule does not raise an issue when an ASP.NET virtual path is passed as an argument to one of the following:

- methods: `System.Web.HttpServerUtilityBase.MapPath()`, `System.Web.HttpRequestBase.MapPath()`,<br>  `System.Web.HttpResponseBase.ApplyAppPathModifier()`, `System.Web.Mvc.UrlHelper.Content()`
- all methods of: `System.Web.VirtualPathUtility`
- constructors of: `Microsoft.AspNetCore.Mvc.VirtualFileResult`, `Microsoft.AspNetCore.Routing.VirtualPathData`


## See

- [CERT, MSC03-J.](https://www.securecoding.cert.org/confluence/x/qQCHAQ) - Never hard code sensitive information

