
Although unnecessary `using` won't change anything to the produced application, removing them:

- Will help readability and maintenance.
- Will help reduce the number of items in the IDE auto-completion list when coding.
- May avoid some name collisions.
- May improve compilation time because the compiler has fewer namespaces to look-up when it resolves types.
- The build will fail if this namespace is removed from the project.


## Noncompliant Code Example


    using System.Collections.Generic; // Noncompliant - unnecessary using
    
    namespace Foo
    {
        public class Bar
        {
            public Bar(string path)
            {
                File.ReadAllLines(path);
            }
        }
    }


## Compliant Solution


    using System.IO;
    
    namespace Foo
    {
        public class Bar
        {
            public Bar(string path)
            {
                File.ReadAllLines(path);
            }
        }
    }

