
The purpose of an abstract class is to provide some heritable behaviors while also defining methods which must be implemented by sub-classes.

A `class` with no abstract methods that was made `abstract` purely to prevent instantiation should be converted to a concrete `class` (i.e. remove the `abstract` keyword) with a `protected` constructor.

A `class` with only `abstract` methods and no inheritable behavior should be converted to an `interface`.

## Noncompliant Code Example


    public abstract class Animal //Noncompliant; should be an interface
    {
      abstract void Move();
      abstract void Feed();
    }
    
    public abstract class Color //Noncompliant; should be concrete with a private constructor
    {
      private int red = 0;
      private int green = 0;
      private int blue = 0;
    
      public int GetRed()
      {
        return red;
      }
    }


## Compliant Solution


    public interface Animal
    {
      void Move();
      void Feed();
    }
    
    public class Color
    {
      private int red = 0;
      private int green = 0;
      private int blue = 0;
    
      protected Color()
      {}
    
      public int GetRed()
      {
        return red;
      }
    }
    
    public abstract class Lamp
    {
      private bool switchLamp = false;
    
      public abstract void Glow();
    
      public void FlipSwitch()
      {
        switchLamp = !switchLamp;
        if (switchLamp)
        {
          Glow();
        }
      }
    }

