
The use of non-short-circuit logic in a boolean context is likely a mistake - one that could cause serious program errors as conditions are evaluated under the wrong circumstances.

## Noncompliant Code Example


    if (GetTrue() | GetFalse()) // Noncompliant; both sides evaluated
    {
    }


## Compliant Solution


    if (GetTrue() || GetFalse()) // true short-circuit logic
    {
    }


## See

- [CERT, EXP46-C.](https://www.securecoding.cert.org/confluence/x/g4FtAg) - Do not use a bitwise operator with a Boolean-like operand<br>

