
When the call to a function doesn't have any side effects, what is the point of making the call if the results are ignored? In such case, either the function call is useless and should be dropped or the source code doesn't behave as expected.

This rule raises an issue when the results of the following methods are ignored:

- LINQ method,
- `[Pure]` method,
- any method on `string`, `int`, ..., `System.Collections.Immutable.ImmutableArray<T>`,<br>  `ImmutableHashSet<T>`, ...


Notes:

- although `string.Intern` has a side effect, ignoring its return value is still suspicious as it is the only reference ensured to<br>  point to the intern pool.
- Link methods can have side effects if they are misused. Example:



    tests.All(c =&gt; { c.myfield = "foo"; return true; });


Such code should be rewritten as a normal loop.

## Noncompliant Code Example


    coll.Where(i =&gt; i &gt; 5).Select(i =&gt; i*i); // Noncompliant
    "this string".Equals("other string"); // Noncompliant


## Compliant Solution


    var res = coll.Where(i =&gt; i &gt; 5).Select(i =&gt; i*i);
    var isEqual = "this string".Equals("other string");


## Exceptions

This rule doesn't report issues on method calls with `out` or `ref` arguments.

## See

- [CERT, EXP12-C.](https://www.securecoding.cert.org/confluence/x/9YIRAQ) - Do not ignore values returned by functions
- [CERT, EXP00-J.](https://www.securecoding.cert.org/confluence/x/9gEqAQ) - Do not ignore values returned by methods

