
According to the US National Institute of Standards and Technology (NIST), the Data Encryption Standard (DES) is no longer considered secure:


> Adopted in 1977 for federal agencies to use in protecting sensitive, unclassified information, the DES is being withdrawn because it no longer   provides the security that is needed to protect federal government information.
> 
> Federal agencies are encouraged to use the Advanced Encryption Standard, a faster and stronger algorithm approved as FIPS 197 in 2001.


For similar reasons, RC2 should also be avoided.

## Noncompliant Code Example


    using (var tripleDES = new TripleDESCryptoServiceProvider()) //Noncompliant
    {
      //...
    }


## Compliant Solution


    using (var aes = new AesCryptoServiceProvider())
    {
      //...
    }


## See

- [OWASP Top 10 2017 Category A6](https://www.owasp.org/index.php/Top_10-2017_A6-Security_Misconfiguration) - Security<br>  Misconfiguration
- [MITRE, CWE-326](http://cwe.mitre.org/data/definitions/326.html) - Inadequate Encryption Strength
- [MITRE, CWE-327](http://cwe.mitre.org/data/definitions/327.html) - Use of a Broken or Risky Cryptographic Algorithm
- [CERT, MSC61-J.](https://www.securecoding.cert.org/confluence/x/VwAZAg) - Do not use insecure or weak cryptographic algorithms
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat3) - Porous Defenses
- Derived from FindSecBugs rule [DES / DESede Unsafe](http://h3xstream.github.io/find-sec-bugs/bugs.htm#DES_USAGE)


## Deprecated

This rule is deprecated; use {rule:csharpsquid:S5547} instead.
