
Because parameter names could be changed during refactoring, they should not be spelled out literally in strings. Instead, use `nameof()`, and the string that's output will always be correct.

This rule raises an issue when a string in the `throw` statement contains the name of one of the method parameters.

## Noncompliant Code Example


    void DoSomething(int someParameter, string anotherParam)
    {
        if (someParameter &lt; 0)
        {
            throw new ArgumentException("Bad argument", "someParameter");  // Noncompliant
        }
        if (anotherParam == null)
        {
            throw new Exception("anotherParam should not be null"); // Noncompliant
        }
    }


## Compliant Solution


    void DoSomething(int someParameter)
    {
        if (someParameter &lt; 0)
        {
            throw new ArgumentException("Bad argument", nameof(someParameter));
        }
        if (anotherParam == null)
        {
            throw new Exception($"{nameof(anotherParam)} should not be null");
        }
    }


## Exceptions

- The rule doesn't raise any issue when using C# &lt; 6.0.
- When the parameter name is contained in a sentence inside the `throw` statement string, the rule will raise an issue only if the<br>  parameter name is at least 5 characters long. This is to avoid false positives.

