
When multiple, adjacent `try` statements have duplicate `catch` and/or `finally` blocks, they should be merged to consolidate the `catch/finally` logic for cleaner, more readable code. Note that this applies even when there is intervening code outside any `try` block.

## Noncompliant Code Example


    try
    {
      DoTheFirstThing(a, b);
    }
    catch (InvalidOperationException ex)
    {
      HandleException(ex);
    }
    
    DoSomeOtherStuff();
    
    try  // Noncompliant; catch is identical to previous
    {
      DoTheSecondThing();
    }
    catch (InvalidOperationException ex)
    {
      HandleException(ex);
    }
    
    try  // Compliant; catch handles exception differently
    {
      DoTheThirdThing(a);
    }
    catch (InvalidOperationException ex)
    {
      LogAndDie(ex);
    }


## Compliant Solution


    try
    {
      DoTheFirstThing(a, b);
      DoSomeOtherStuff();
      DoTheSecondThing();
    }
    catch (InvalidOperationException ex)
    {
      HandleException(ex);
    }
    
    try  // Compliant; catch handles exception differently
    {
      DoTheThirdThing(a);
    }
    catch (InvalidOperationException ex)
    {
      LogAndDie(ex);
    }

