
Shared naming conventions allow teams to collaborate efficiently. This rule checks that all `enum` names match a provided regular expression.

The default configuration is the one recommended by Microsoft:

- Pascal casing, starting with an upper case character, e.g. BackColor
- Short abbreviations of 2 letters can be capitalized, e.g. GetID
- Longer abbreviations need to be lower case, e.g. GetHtml
- If the enum is marked as [Flags] then its name should be plural (e.g. MyOptions), otherwise, names should be singular (e.g. MyOption)


## Noncompliant Code Example

With the default regular expression for non-flags enums: `^([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?$`


    public enum foo // Noncompliant
    {
        FooValue = 0
    }


With the default regular expression for flags enums: `^([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?s$`


    [Flags]
    public enum Option // Noncompliant
    {
        None = 0,
        Option1 = 1,
        Option2 = 2
    }


## Compliant Solution


    public enum Foo
    {
        FooValue = 0
    }



    [Flags]
    public enum Options
    {
        None = 0,
        Option1 = 1,
        Option2 = 2
    }

