
A test case without assertions ensures only that no exceptions are thrown. Beyond basic runnability, it ensures nothing about the behavior of the code under test.

This rule raises an exception when no assertions from any of the following frameworks are found in a test:

- `MSTest`
- `NUnit`
- `XUnit`
- `FluentAssertions` (4.x and 5.x)
- `NSubstitute`


## Noncompliant Code Example


    [TestMethod]
    public void MyMethod_WhenSomething_ExpectsSomething()
    {
        var myClass = new Class();
        var result = myClass.GetFoo();
    }


## Compliant Solution


    [TestMethod]
    public void MyMethod_WhenSomething_ExpectsSomething()
    {
        var myClass = new Class();
        var result = myClass.GetFoo();
        Assert.IsTrue(result);
    }

