
This rule raises an issue when reflection is used to change the visibility of a class, method or field, and when it is used to directly update a field value. Altering or bypassing the accessibility of classes, methods, or fields violates the encapsulation principle and could lead to run-time errors.

## Noncompliant Code Example


    using System.Reflection;
    
    Type dynClass = Type.GetType("MyInternalClass");
    // Noncompliant. Using BindingFlags.NonPublic will return non-public members
    BindingFlags bindingAttr = BindingFlags.NonPublic | BindingFlags.Static;
    MethodInfo dynMethod = dynClass.GetMethod("mymethod", bindingAttr);
    object result = dynMethod.Invoke(dynClass, null);


## See

- [CERT, SEC05-J.](https://www.securecoding.cert.org/confluence/x/3YEVAQ) - Do not use reflection to increase accessibility of<br>  classes, methods, or fields

