
Static field initializers are executed in the order in which they appear in the class from top to bottom. Thus, placing a static field in a class above the field or fields required for its initialization will yield unexpected results.

## Noncompliant Code Example


    class MyClass
    {
      public static int X = Y; // Noncompliant; Y at this time is still assigned default(int), i.e. 0
      public static int Y = 42;
    }


## Compliant Solution


    class MyClass
    {
      public static int Y = 42;
      public static int X = Y;
    }


or


    class MyClass
    {
      public static int X;
      public static int Y = 42;
    
      static MyClass()
      {
        X = Y;
      }
    }

