
`enum`s are usually used to identify distinct elements in a set of values. However `enum`s can be treated as bit fields and bitwise operations can be used on them to combine the values. This is a good way of specifying multiple elements of set with a single value. When `enum`s are used this way, it is a best practice to mark the `enum` with the `FlagsAttribute`.

## Noncompliant Code Example


    enum Permissions
    {
      None = 0,
      Read = 1,
      Write = 2,
      Execute = 4
    }
    // ...
    
    var x = Permissions.Read | Permissions.Write;  // Noncompliant; enum is not marked with [Flags]


## Compliant Solution


    [Flags]
    enum Permissions
    {
      None = 0,
      Read = 1,
      Write = 2,
      Execute = 4
    }
    // ...
    
    var x = Permissions.Read | Permissions.Write;

