
Empty `case` clauses that fall through to the default are useless. Whether or not such a `case` is present, the `default` clause will be invoked. Such `case`s simply clutter the code, and should be removed.

## Noncompliant Code Example


    switch(ch)
    {
      case 'a' :
        HandleA();
        break;
      case 'b' :
        HandleB();
        break;
      case 'c' :  // Noncompliant
      default:
        HandleTheRest();
        break;
    }


## Compliant Solution


    switch(ch)
    {
      case 'a' :
        HandleA();
        break;
      case 'b' :
        HandleB();
        break;
      default:
        HandleTheRest();
        break;
    }

