
Calling `GetType()` on a nullable object returns the underlying value type. Thus, comparing the returned `Type` object to `typeof(Nullable<SomeType>)` doesn't make sense. The comparison either throws an exception or the result can be known at compile time.

## Noncompliant Code Example


    int? nullable = 42;
    bool comparison = nullable.GetType() == typeof(Nullable&lt;int&gt;); // Noncompliant, always false
    comparison = nullable.GetType() != typeof(Nullable&lt;int&gt;); // Noncompliant, always true
    
    nullable = null;
    comparison = nullable.GetType() != typeof(Nullable&lt;int&gt;); // Noncompliant, calling GetType on a null always throws an exception

