
The `IEquatable<T>` interface has only one method in it: `Equals(<T>)`. If you've already written `Equals(T)`, there's no reason not to explicitly implement `IEquatable<T>`. Doing so expands the utility of your class by allowing it to be used where an `IEquatable` is called for.

Note\*\*: Classes that implement `IEquatable<T>` should also be `sealed`.

## Noncompliant Code Example


    class MyClass  // Noncompliant
    {
      public bool Equals(MyClass other)
      {
        //...
      }
    }


## Compliant Solution


    sealed class MyClass : IEquatable&lt;MyClass&gt;
    {
      public override bool Equals(object other)
      {
        return Equals(other as MyClass);
      }
    
      public bool Equals(MyClass other)
      {
        //...
      }
    }

