
If no `AssemblyVersionAttribute` is provided, the same default version will be used for every build. Since the version number is used by The .NET Framework to uniquely identify an assembly this can lead to broken dependencies.

## Noncompliant Code Example


    using System;
    using System.Reflection;
    
    [assembly: AssemblyTitle("MyAssembly")] // Noncompliant
    
    namespace MyLibrary
    {
    }


## Compliant Solution


    using System;
    using System.Reflection;
    
    [assembly: AssemblyTitle("MyAssembly")]
    [assembly: AssemblyVersion("1.2.125.0")]
    
    namespace MyLibrary
    {
    }


## See

[Assembly Versioning (MSDN)](https://msdn.microsoft.com/en-us/library/51ket42z.aspx)
