
Serialization event handlers that don't have the correct signature will simply not be called, thus bypassing any attempts to augment the automated de/serialization.

This rule raises issue when a method marked with one of the following attributes is not `private`, does not return `void`, has type parameters, or does not have a single parameter of type `System.Runtime.Serialization.StreamingContext`:

- `System.Runtime.Serialization.OnSerializingAttribute`
- `System.Runtime.Serialization.OnSerializedAttribute`
- `System.Runtime.Serialization.OnDeserializingAttribute`
- `System.Runtime.Serialization.OnDeserializedAttribute`


## Noncompliant Code Example


    [Serializable]
    public class Foo
    {
        [OnSerializing]
        public void OnSerializing(StreamingContext context) {} // Noncompliant should be private
    
        [OnSerialized]
        int OnSerialized(StreamingContext context) {} // Noncompliant should return void
    
        [OnDeserializing]
        void OnDeserializing() {} // Noncompliant should have a single parameter of type StreamingContext
    
        [OnSerializing]
        public void OnSerializing2&lt;T&gt;(StreamingContext context) {} // Noncompliant should have no type parameters
    
        [OnDeserialized]
        void OnDeserialized(StreamingContext context, string str) {} // Noncompliant should have a single parameter of type StreamingContext
    }


## Compliant Solution


    [Serializable]
    public class Foo
    {
        [OnSerializing]
        private void OnSerializing(StreamingContext context) {}
    
        [OnSerialized]
        private void OnSerialized(StreamingContext context) {}
    
        [OnDeserializing]
        private void OnDeserializing(StreamingContext context) {}
    
        [OnDeserialized]
        private void OnDeserialized(StreamingContext context) {}
    }

