
A jagged array is an array whose elements are arrays. It is recommended over a multidimensional array because the arrays that make up the elements can be of different sizes, which avoids wasting memory space.

## Noncompliant Code Example


    int [,] myArray =  // Noncompliant
        {
            {1,2,3,4},
            {5,6,7,0},
            {8,0,0,0},
            {9,0,0,0}
        };
    // ...
    myArray[1,1] = 0;


## Compliant Solution


    int[][] myArray =
        {
            new int[] {1,2,3,4},
            new int[] {5,6,7},
            new int[] {8},
            new int[] {9}
        };
    // ...
    myArray[1][1] = 0;

