
String representations of URIs or URLs are prone to parsing and encoding errors which can lead to vulnerabilities. The `System.Uri` class is a safe alternative and should be preferred.

This rule raises an issue when a property is a string type and its name contains "uri", "Uri", "urn", "Urn", "url" or "Url".

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
       public class MyClass
       {
          string myUri;
    
          public string MyUri // Noncompliant
          {
             get { return myURI; }
             set { myUri = value; }
          }
       }
    }


## Compliant Solution


    using System;
    
    namespace MyLibrary
    {
       public class MyClass
       {
          Uri myUri;
    
          public Uri MyUri
          {
             get { return myURI; }
             set { myUri = value; }
          }
       }
    }

