
Having a field in a child class with a name that differs from a parent class' field only by capitalization is sure to cause confusion. Such child class fields should be renamed.

## Noncompliant Code Example


    public class Fruit
    {
      protected string plantingSeason;
      //...
    }
    
    public class Raspberry : Fruit
    {
      protected string plantingseason;  // Noncompliant
      // ...
    }


## Compliant Solution


    public class Fruit
    {
      protected string plantingSeason;
      //...
    }
    
    public class Raspberry : Fruit
    {
      protected string whenToPlant;
      // ...
    }


Or


    public class Fruit
    {
      protected string plantingSeason;
      //...
    }
    
    public class Raspberry : Fruit
    {
      // field removed; parent field will be used instead
      // ...
    }

