
Exceptions types should provide the following constructors:

- `public MyException()`
- `public MyException(string)`
- `public MyException(string, Exception)`
- `protected` or `private MyException(SerializationInfo, StreamingContext)`


That fourth constructor should be `protected` in unsealed classes, and `private` in sealed classes.

Not having this full set of constructors can make it difficult to handle exceptions.

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
      public class MyException // Noncompliant: several constructors are missing
      {
        public MyException()
        {
        }
      }
    }


## Compliant Solution


    using System;
    using System.Runtime.Serialization;
    
    namespace MyLibrary
    {
      public class MyException : Exception
      {
          public MyException()
          {
          }
    
          public MyException(string message)
              :base(message)
          {
          }
    
          public MyException(string message, Exception innerException)
              : base(message, innerException)
          {
          }
    
          protected MyException(SerializationInfo info, StreamingContext context)
              : base(info, context)
          {
          }
      }
    }

