
Properties are accessed like fields which makes them easier to use.

This rule raises an issue when the name of a `public` or `protected` method starts with `Get`, takes no parameter, and returns a value that is not an array.

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
        public class Foo
        {
            private string name;
    
            public string GetName()  // Noncompliant
            {
                return name;
            }
        }
    }


## Compliant Solution


    using System;
    
    namespace MyLibrary
    {
        public class Foo
        {
            private string name;
    
            public string Name
            {
                get
                {
                    return name;
                }
            }
        }
    }


## Exceptions

The rule doesn't raise an issue when the method:

- Is a constructor
- Is an `override`
- Is an interface implementation
- Is `async`
- Returns `Task`, `Task<T>`
- Is named `GetEnumerator`, `GetAwaiter`

