
With the advent of .NET framework version 2, certain practices have become obsolete.

In particular, exceptions should now extend `System.Exception` instead of `System.ApplicationException`. Similarly, generic collections should be used instead of the older, non-generic, ones. Finally when creating an XML view, you should not extend `System.Xml.XmlDocument`.

This rule raises an issue when an externally visible type extends one of these types:

- `System.ApplicationException`
- `System.Xml.XmlDocument`
- `System.Collections.CollectionBase`
- `System.Collections.DictionaryBase`
- `System.Collections.Queue`
- `System.Collections.ReadOnlyCollectionBase`
- `System.Collections.SortedList`
- `System.Collections.Stack`


## Noncompliant Code Example


    using System;
    using System.Collections;
    
    namespace MyLibrary
    {
      public class MyCollection : CollectionBase  // Noncompliant
      {
      }
    }


## Compliant Solution


    using System;
    using System.Collections;
    
    namespace MyLibrary
    {
      public class MyCollection : Collection&lt;T&gt;
      {
      }
    }

