
According to the Task-based Asynchronous Pattern (TAP), methods returning either a `System.Threading.Tasks.Task` or a `System.Threading.Tasks.Task<TResult>` are considered "asynchronous". Such methods should use the `Async` suffix. Conversely methods which do not return such Tasks should not have an "Async" suffix in their names.

## Noncompliant Code Example


    using System;
    using  System.Threading.Tasks;
    
    namespace myLibrary
    {
    
      public class Foo
      {
        public Task Read(byte [] buffer, int offset, int count, // Noncompliant
                                    CancellationToken cancellationToken)
      }
    }


## Compliant Solution


    using System;
    using  System.Threading.Tasks;
    
    namespace myLibrary
    {
    
      public class Foo
      {
        public Task ReadAsync(byte [] buffer, int offset, int count, CancellationToken cancellationToken)
      }
    }


## Exceptions

This rule doesn't raise an issue when the method is an override or part of the implementation of an interface since it can not be renamed.

## See

- [Task-based<br>  Asynchronous Pattern](https://docs.microsoft.com/en-us/dotnet/standard/asynchronous-programming-patterns/task-based-asynchronous-pattern-tap)

