
Properties provide a way to enforce encapsulation by providing `public`, `protected` or `internal` methods that give controlled access to `private` fields. However in classes with multiple fields it is not unusual that cut and paste is used to quickly create the needed properties, which can result in the wrong field being accessed by a getter or setter.

This rule raises an issue in any of these cases:

- A setter does not update the field with the corresponding name.
- A getter does not access the field with the corresponding name.


For simple properties it is better to use [auto-implemented<br>properties](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/auto-implemented-properties) (C# 3.0 or later).

Field and property names are compared as case-insensitive. All underscore characters are ignored.

## Noncompliant Code Example


    class A
    {
        private int x;
        private int y;
    
        public int X
        {
            get { return x; }
            set { x = value; }
        }
    
        public int Y
        {
            get { return x; }  // Noncompliant: field 'y' is not used in the return value
            set { x = value; } // Noncompliant: field 'y' is not updated
        }
    }


## Compliant Solution


    class A
    {
        private int x;
        private int y;
    
        public int X
        {
            get { return x; }
            set { x = value; }
        }
    
        public int Y
        {
            get { return y; }
            set { y = value; }
        }
    }

