
An LDAP client authenticates to an LDAP server with a "bind request" which provides, among other, a [simple authentication method](https://ldapwiki.com/wiki/Simple%20Authentication).

Simple authentication in LDAP can be used with three different mechanisms:

- *Anonymous Authentication Mechanism* by performing a bind request with a username and password value of zero length.
- *Unauthenticated Authentication Mechanism* by performing a bind request with a password value of zero length.
- *Name/Password Authentication Mechanism* by performing a bind request with a password value of non-zero length.


Anonymous binds and unauthenticated binds allow access to information in the LDAP directory without providing a password, their use is therefore strongly discouraged.

## Noncompliant Code Example

This rule raises an issue when an LDAP connection is created with `AuthenticationTypes.Anonymous` or `AuthenticationTypes.None`.


    DirectoryEntry myDirectoryEntry = new DirectoryEntry(adPath);
    myDirectoryEntry.AuthenticationType = AuthenticationTypes.None; // Noncompliant
    
    DirectoryEntry myDirectoryEntry = new DirectoryEntry(adPath, "u", "p", AuthenticationTypes.None); // Noncompliant


## Compliant Solution


    DirectoryEntry myDirectoryEntry = new DirectoryEntry(myADSPath); // Compliant; default DirectoryEntry.AuthenticationType property value is "Secure" since .NET Framework 2.0
    
    DirectoryEntry myDirectoryEntry = new DirectoryEntry(myADSPath, "u", "p", AuthenticationTypes.Secure);


## See

- [OWASP Top 10 2017 Category A2](https://www.owasp.org/index.php/Top_10-2017_A2-Broken_Authentication) - Broken Authentication
- [CWE-521](https://cwe.mitre.org/data/definitions/521.html) - Weak Password Requirements
- [ldapwiki.com](https://ldapwiki.com/wiki/Simple%20Authentication)- Simple Authentication

