
Returning `null` from a non-`async` `Task`/`Task<T>` method will cause a `NullReferenceException` at runtime. This problem can be avoided by returning `Task.FromResult<T>(null)` instead.

## Noncompliant Code Example


    public Task&lt;object&gt; GetFooAsync()
    {
        return null; // Noncompliant
    }


## Compliant Solution


    public Task&lt;object&gt; GetFooAsync()
    {
        return Task.FromResult&lt;object&gt;(null);
    }

