
Reading Standard Input is security-sensitive. It has led in the past to the following vulnerabilities:

- [CVE-2005-2337](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2005-2337)
- [CVE-2017-11449](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-11449)


It is common for attackers to craft inputs enabling them to exploit software vulnerabilities. Thus any data read from the standard input (stdin) can be dangerous and should be validated.

This rule flags code that reads from the standard input.

## Ask Yourself Whether

- data read from the standard input is not sanitized before being used.


You are at risk if you answered yes to this question.

## Recommended Secure Coding Practices

[Sanitize](https://www.owasp.org/index.php/Input_Validation_Cheat_Sheet) all data read from the standard input before using it.

## Sensitive Code Example


    using System;
    public class C
    {
        public void Main()
        {
            Console.In; // Sensitive
            var code = Console.Read(); // Sensitive
            var keyInfo = Console.ReadKey(...); // Sensitive
            var text = Console.ReadLine(); // Sensitive
            Console.OpenStandardInput(...); // Sensitive
        }
    }


## Exceptions

This rule does not raise issues when the return value of the `Console.Read` `Console.ReadKey` or `Console.ReadLine` methods is ignored.


    using System;
    public class C
    {
        public void Main()
        {
            Console.ReadKey(...); // Return value is ignored
            Console.ReadLine(); // Return value is ignored
        }
    }


## See:

- [MITRE, CWE-20](https://cwe.mitre.org/data/definitions/20.html) - Improper Input Validation

