
To perform secure cryptography, operation modes and padding scheme are essentials and should be used correctly according to the encryption algorithm:

- For block cipher encryption algorithms (like AES), the GCM (Galois Counter Mode) mode, which [works internally](https://en.wikipedia.org/wiki/Galois/Counter_Mode#Mathematical_basis)with zero/no padding scheme, is recommended. At the<br>  opposite, these modes and/or schemes are highly discouraged:
    - Electronic Codebook (ECB) mode is vulnerable because it doesn't provide serious message confidentiality: under a given key any given<br>      plaintext block always gets encrypted to the same ciphertext block.
    - Cipher Block Chaining (CBC) with PKCS#5 padding (or PKCS#7) is susceptible to padding oracle attacks.
- RSA encryption algorithm should be used with the recommended padding scheme (OAEP)


## Noncompliant Code Example

[AesManaged](https://docs.microsoft.com/en-us/dotnet/api/system.security.cryptography.aesmanaged?view=netframework-4.8) object with insecure mode:


    AesManaged aes4 = new AesManaged
    {
      KeySize = 128,
      BlockSize = 128,
      Mode = CipherMode.ECB, // Noncompliant
      Padding = PaddingMode.PKCS7
    };


[RSACryptoServiceProvider](https://docs.microsoft.com/en-us/dotnet/api/system.security.cryptography.rsacryptoserviceprovider?view=netframework-4.8) object without OAEP padding:


    RSACryptoServiceProvider RSA1 = new RSACryptoServiceProvider();
    encryptedData = RSA1.Encrypt(dataToEncrypt, false); // Noncompliant: OAEP Padding is not used (second parameter set to false)


## Compliant Solution

AES with GCM mode with [bouncycastle](https://www.bouncycastle.org/) library:


    GcmBlockCipher blockCipher = new GcmBlockCipher(new AesEngine()); // Compliant
    blockCipher.Init(true, new AeadParameters(new KeyParameter(secretKey), 128, iv, null));


AES with GCM mode with [AesGcm](https://docs.microsoft.com/en-us/dotnet/api/system.security.cryptography.aesgcm?view=netcore-3.0) object:


    var aesGcm = new AesGcm(key); // Compliant


RSA with OAEP padding with [RSACryptoServiceProvider](https://docs.microsoft.com/en-us/dotnet/api/system.security.cryptography.rsacryptoserviceprovider?view=netframework-4.8) object:


    RSACryptoServiceProvider RSA2 = new RSACryptoServiceProvider();
    encryptedData = RSA2.Encrypt(dataToEncrypt, true); // Compliant: OAEP Padding is used (second parameter set to true)




## See

- [OWASP Top 10 2017 Category A6](https://www.owasp.org/index.php/Top_10-2017_A6-Security_Misconfiguration) - Security<br>  Misconfiguration
- [MITRE, CWE-327](http://cwe.mitre.org/data/definitions/327.html) - Use of a Broken or Risky Cryptographic Algorithm
- [CERT, MSC61-J.](https://www.securecoding.cert.org/confluence/x/VwAZAg) - Do not use insecure or weak cryptographic algorithms
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat3) - Porous Defenses

