
If a JSON Web Token (JWT) is not signed with a strong cipher algorithm (or not signed at all) an attacker can forge it and impersonate user identities.

- Don't use `none` algorithm to sign or verify the validity of an algorithm.
- Don't use a token without verifying its signature before.


## Noncompliant Code Example

[jwt-dotnet](https://github.com/jwt-dotnet/jwt) library:


    var decodedtoken1 = decoder.Decode(token, secret, verify: false); // Noncompliant: signature should be verified
    
    var decodedtoken2 = new JwtBuilder()
       .WithSecret(secret)
       .Decode(forgedtoken1); // Noncompliant: signature should be verified


## Compliant Solution

[jwt-dotnet](https://github.com/jwt-dotnet/jwt) library:


    var decodedtoken1 = decoder.Decode(forgedtoken1, secret, verify: true); // Compliant
    
    var decodedtoken2 = new JwtBuilder()
       .WithSecret(secret)
       .MustVerifySignature()
       .Decode(token); // Compliant


## See

- [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure<br>
- [MITRE, CWE-347](https://cwe.mitre.org/data/definitions/347.html) - Improper Verification of Cryptographic Signature

