
Sharing some naming conventions is a key point to make it possible for a team to efficiently collaborate. This rule allows to check that all class names match a provided regular expression.

The default configuration is the one recommended by Microsoft:

- Pascal casing, starting with an upper case character, e.g. BackColor
- Short abbreviations of 2 letters can be capitalized, e.g. GetID
- Longer abbreviations need to be lower cased, e.g. GetHtml


## Noncompliant Code Example

With the default regular expression `^([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?$`:


    Class foo ' Noncompliant
    End Class


## Compliant Solution


    Class Foo ' Compliant
    End Class

