
The use of parentheses, even those not required to enforce a desired order of operations, can clarify the intent behind a piece of code. But redundant pairs of parentheses could be misleading, and should be removed.

## Noncompliant Code Example


    If a AndAlso ((x + y &gt; 0)) Then ' Noncompliant
        ' ...
    End If
    
    Return ((x + 1))  ' Noncompliant


## Compliant Solution


    If a AndAlso x + y &gt; 0 Then
        ' ...
    End If
    
    Return (x + 1)

