
Throwing such general exceptions as `Exception`, `SystemException`, `ApplicationException`, `IndexOutOfRangeException`, `NullReferenceException`, `OutOfMemoryException` and `ExecutionEngineException` prevents calling methods from handling true, system-generated exceptions differently than application-generated errors.

## Noncompliant Code Example


    Public Sub DoSomething(obj As Object)
      If obj Is Nothing Then
        ' Noncompliant
        Throw New NullReferenceException("obj")
      End If
      ' ...
    End Sub


## Compliant Solution


    Public Sub DoSomething(obj As Object)
      If obj Is Nothing Then
        Throw New ArgumentNullException("obj")
      End If
      ' ...
    End Sub


## See

- [MITRE, CWE-397](http://cwe.mitre.org/data/definitions/397.html) - Declaration of Throws for Generic Exception
- [CERT, ERR07-J.](https://www.securecoding.cert.org/confluence/x/BoB3AQ) - Do not throw RuntimeException, Exception, or Throwable<br>

