
Redundant Boolean literals should be removed from expressions to improve readability.

## Noncompliant Code Example


    If BooleanMethod() = True Then ' Noncompliant
      ' ...
    End If
    If BooleanMethod() = False Then ' Noncompliant
      ' ...
    End If
    If BooleanMethod() OrElse False Then ' Noncompliant
      ' ...
    End If
    DoSomething(Not False) ' Noncompliant
    DoSomething(BooleanMethod() = True) ' Noncompliant
    
    Dim booleanVariable = If(BooleanMethod(), True, False) ' Noncompliant
    booleanVariable = If(BooleanMethod(), True, exp) ' Noncompliant
    booleanVariable = If(BooleanMethod(), False, exp) ' Noncompliant
    booleanVariable = If(BooleanMethod(), exp, True) ' Noncompliant
    booleanVariable = If(BooleanMethod(), exp, False) ' Noncompliant


## Compliant Solution


    If BooleanMethod() Then
      ' ...
    End If
    If Not BooleanMethod() Then
      ' ...
    End If
    If BooleanMethod() Then
      ' ...
    End If
    DoSomething(True)
    DoSomething(BooleanMethod())
    
    Dim booleanVariable = BooleanMethod()
    booleanVariable = BooleanMethod() OrElse exp
    booleanVariable = Not BooleanMethod() AndAlso exp
    booleanVariable = Not BooleanMethod() OrElse exp
    booleanVariable = BooleanMethod() AndAlso exp

