
The `Select...Case` statement should be used only to clearly define some new branches in the control flow. As soon as a case clause contains too many statements this highly decreases the readability of the overall control flow statement. In such case, the content of the case clause should be extracted into a dedicated procedure.

## Noncompliant Code Example

With the default threshold of 3:


    Select Case number
        Case 1 To 5 ' Noncompliant: 4 statements in the case
            MethodCall1("")
            MethodCall2("")
            MethodCall3("")
            MethodCall4("")
        Case Else
            ' ...
    End Select


## Compliant Solution


    Select Case number
        Case 1 To 5
            DoSomething()
        Case Else
            ' ...
    End Select
    ...
    Sub DoSomething()
        MethodCall1("")
        MethodCall2("")
        MethodCall3("")
        MethodCall4("")
    End Sub

