
Unused parameters are misleading. Whatever the values passed to such parameters, the behavior will be the same.

This rule raises an issue when a `private` procedure of a `Class`, `Module` or `Structure` takes a parameter without using it.

## Noncompliant Code Example


    Private Sub DoSomething(ByVal a As Integer, ByVal b as Integer) ' "b" is unused
        Compute(a)
    End Sub
    
    Private Function DoSomething2(ByVal a As Integer, ByVal b As Integer) As Integer ' "a" is unused
        Compute(b)
        Return b
    End Function


## Compliant Solution


    Private Sub DoSomething(ByVal a As Integer)
        Compute(a)
    End Sub
    
    Private Function DoSomething2(ByVal b As Integer) As Integer
        Compute(b)
        Return b
    End Function


## Exceptions

This rule doesn't raise any issue in the following contexts:

- Procedures decorated with attributes.
- Empty procedures.
- Procedures which only throw `NotImplementedException`.
- Main methods.
- `virtual`, `override` procedures.
- Interface implementations.
- Event handlers.


## See

- [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never<br>  executed

