
There are several reasons for a method not to have a method body:

- It is an unintentional omission, and should be fixed.
- It is not yet, or never will be, supported. In this case a `NotSupportedException` should be thrown.
- The method is an intentionally-blank override. In this case a nested comment should explain the reason for the blank override.


## Noncompliant Code Example


    Sub DoSomething()
    End Sub
    
    Function DoSomething()
    End Function


## Compliant Solution


    Sub DoSomething()
        ' Not implemented because of reason
    End Sub
    
    Function DoSomething()
        Throw New NotSupportedException
    End Function


## Exceptions

The following methods are ignored:

- empty `Overridable` or `MustOverride` methods,
- empty methods that override an `MustOverride` method,
- empty overrides in test assemblies.

