
This rule applies whenever an `If` statement is followed by one or more `ElseIf` statements; the final `ElseIf` should be followed by an `Else` statement.

The requirement for a final `Else` statement is defensive programming.

The `Else` statement should either take appropriate action or contain a suitable comment as to why no action is taken. This is consistent with the requirement to have a final `Case Else` clause in a `Select Case` statement.

## Noncompliant Code Example


    If x = 0 Then
        DoSomething()
    ElseIf x = 1 Then
        DoSomethingElse()
    End If


## Compliant Solution


    If x = 0 Then
        DoSomething()
    ElseIf x = 1 Then
        DoSomethingElse()
    Else
        Throw New ArgumentException("...")
    End If


## Exceptions

None

## See

- [CERT, MSC01-C.](https://www.securecoding.cert.org/confluence/x/YgE) - Strive for logical completeness
- [CERT, MSC57-J.](https://www.securecoding.cert.org/confluence/x/PQHRAw) - Strive for logical completeness

