
When `Select Case` statements have large sets of case clauses, it is usually an attempt to map two sets of data. A `Dictionary` should be used instead to make the code more readable and maintainable.

## Noncompliant Code Example

With a "Maximum number of case" set to 4


    Public Class TooManyCase
    
        Public Function SelectCase(Ch As Char) As Integer
            Select Case Ch
                Case "a"c
                    Return 1
                Case "b"c, "c"c
                    Return 2
                Case "d"c
                    Return 3
                Case "e"c
                    Return 4
                Case "f"c, "g"c, "h"c
                    Return 5
                Case Else
                    Return 6
            End Select
        End Function
    
    End Class


## Compliant Solution


    Public Class TooManyCase
    
        Private fMatching As New Dictionary(Of Char, Integer) From {
                {"a"c, 1}, {"b"c, 2}, {"c"c, 2}, {"d"c, 3},
                {"e"c, 4}, {"f"c, 5}, {"g"c, 5}, {"h"c, 5},
            }
    
        Public Function SelectCase(Ch As Char) As Integer
            Dim Value As Integer
            If fMatching.TryGetValue(Ch, Value) Then
                Return Value
            Else
                Return 6
            End If
        End Function
    
    End Class


## Exceptions

This rule ignores `Select Case`s over `Enum`s and empty, fall-through cases.
