
If a local variable is declared but not used, it is dead code and should be removed. Doing so will improve maintainability because developers will not wonder what the variable is used for.

## Noncompliant Code Example


    Public Function NumberOfMinutes(ByVal hours As Integer) As Integer
        Dim seconds As Integer = 0 ' Seconds never used
        Return hours * 60
    End Function


## Compliant Solution


    Public Function NumberOfMinutes(ByVal hours As Integer) As Integer
        Return hours * 60
    End Function


## Exceptions

Unused locally created resources in a `Using` statement are not reported.


    Using t = New TestTimer()
    End Using

