
Shared naming conventions allow teams to collaborate efficiently. This rule checks that all subroutine and function names match a provided regular expression.

The default configuration is the one recommended by Microsoft:

- Pascal casing, starting with an upper case character, e.g. BackColor
- Short abbreviations of 2 letters can be capitalized, e.g. GetID
- Longer abbreviations need to be lower cased, e.g. GetHtml
- Event handlers with a handles clause and two-parameter methods with `EventArgs` second parameter are not covered by this rule.


## Noncompliant Code Example

With the default regular expression `^([A-Z]{1,3}[a-z0-9]+)*([A-Z]{2})?$`


    Module Module1
      Sub bad_subroutine()                      ' Noncompliant
      End Sub
    
      Public Function Bad_Function() As Integer ' Noncompliant
        Return 42
      End Function
    End Module


## Compliant Solution


    Module Module1
      Sub GoodSubroutine()                      ' Compliant
      End Sub
    
      Public Function GoodFunction() As Integer ' Compliant
        Return 42
      End Function
    End Module

