
`StringBuilder` is more efficient than string concatenation, especially when the operator is repeated over and over as in loops.

## Noncompliant Code Example


    Module Module1
        Sub Main()
            Dim foo = ""
            foo &amp;= "Result: "       ' Compliant - outside of loop
    
            For i = 1 To 9
                foo &amp;= i            ' Noncompliant
            Next
        End Sub
    End Module


## Compliant Solution


    Module Module1
        Sub Main()
            Dim foo = New System.Text.StringBuilder
            foo.Append("Result: ")  ' Compliant
    
            For i = 1 To 9
                foo.Append(i)       ' Compliant
            Next
        End Sub
    End Module

