
There is no reason to re-assign a variable to itself. Either this statement is redundant and should be removed, or the re-assignment is a mistake and some other value or variable was intended for the assignment instead.

## Noncompliant Code Example


    Public Sub SetName(name As String)
      name = name
    End Sub


## Compliant Solution


    Public Sub SetName(name As String)
      Me.name = name
    End Sub


## See

- [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never<br>  executed

