
Declaring multiple variable on one line is difficult to read.

## Noncompliant Code Example


    Module Module1
      Public Const AAA As Integer = 5, BBB = 42, CCC As String = "foo"  ' Noncompliant
    End Module


## Compliant Solution


    Module Module1
      Public Const AAA As Integer = 5
      Public Const BBB = 42
      Public Const CCC as String = "foo"
    End Module


## See

- [CERT, DCL52-J.](https://www.securecoding.cert.org/confluence/x/7wHEAw) - Do not declare more than one variable per declaration<br>
- [CERT, DCL04-C.](https://www.securecoding.cert.org/confluence/x/VgU) - Do not declare more than one variable per declaration

