
A loop with at most one iteration is equivalent to the use of an `if` statement to conditionally execute one piece of code. No developer expects to find such a use of a loop statement. If the initial intention of the author was really to conditionally execute one piece of code, an `if` statement should be used instead.

At worst that was not the initial intention of the author and so the body of the loop should be fixed to use the nested `return`, `break` or `throw` statements in a more appropriate way.

## Noncompliant Code Example


    For i As Integer = 0 To 10   'noncompliant, loop only executes once
      foo(i)
      Exit For
    Next
    ...
    For i As Integer = 0 To 10   'noncompliant, loop only executes once
      If i = Something
        Exit For
      Else
        foo(i)
        Return
      End If
    Next


## Compliant Solution


    For i As Integer = 0 To 10
      foo(i)
    Next
    ...
    For i As Integer = 0 To 10
      If i = Something
        Exit For
      Else
        foo(i)
      End If
    Next

