
Using the same value on either side of a binary operator is almost always a mistake. In the case of logical operators, it is either a copy/paste error and therefore a bug, or it is simply wasted code, and should be simplified. In the case of most binary mathematical operators, having the same value on both sides of an operator yields predictable results, and should be simplified.

This rule ignores `*`, `+`, `&`, `<<`, and `>>`.

## Noncompliant Code Example


    If (a = a) Then
      doZ()
    End If
    
    If a = b OrElse a = b Then
      doW()
    End If
    
    Dim j = 5 / 5
    j = 5 \ 5
    j = 5 Mod 5
    Dim k = 5 - 5
    
    Dim i = 42
    i /= i
    i -= i


## Exceptions

This rule ignores `*`, `+`, and `=`.

## See

- [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never<br>  executed
- {rule:vbnet:S1656} - Implements a check on `=`.

