
A chain of `If`/`ElseIf` statements is evaluated from top to bottom. At most, only one branch will be executed: the first one with a condition that evaluates to `True`.

Therefore, duplicating a condition automatically leads to dead code. Usually, this is due to a copy/paste error. At best, it's simply dead code and at worst, it's a bug that is likely to induce further bugs as the code is maintained, and obviously it could lead to unexpected behavior.

## Noncompliant Code Example


    If param = 1 Then
      OpenWindow()
    ElseIf param = 2 Then
      CloseWindow()
    ElseIf param = 1 Then ' Noncompliant
      MoveWindowToTheBackground()
    End If


## Compliant Solution


    If param = 1 Then
      OpenWindow()
    ElseIf param = 2 Then
      CloseWindow()
    ElseIf param = 3 Then
      MoveWindowToTheBackground()
    End If


## See

- [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never<br>  executed

